// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'hlSkinButton.pas' rev: 6.00

#ifndef hlSkinButtonHPP
#define hlSkinButtonHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Menus.hpp>	// Pascal unit
#include <ActnList.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Hlskinbutton
{
//-- type declarations -------------------------------------------------------
typedef tagRGBTRIPLE TRGBTripleArray[65536];

typedef tagRGBTRIPLE *PRGBTripleArray;

typedef DynamicArray<Types::TRect >  hlSkinButton__2;

class DELPHICLASS ThlBmpToRgn;
class PASCALIMPLEMENTATION ThlBmpToRgn : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Graphics::TBitmap* Bmp;
	int NumRects;
	bool OwnBitmap;
	DynamicArray<Types::TRect >  Rects;
	Graphics::TColor TransColor;
	void __fastcall CountRectangles(void);
	void __fastcall AllocateRectangles(void);
	
public:
	__fastcall ThlBmpToRgn(Graphics::TBitmap* Bitmap, Graphics::TColor TransparentColor);
	__fastcall virtual ~ThlBmpToRgn(void);
	HRGN __fastcall GetRegion(void);
};


class DELPHICLASS ThlCaptionColors;
class PASCALIMPLEMENTATION ThlCaptionColors : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Graphics::TColor FUp;
	Graphics::TColor FDown;
	Graphics::TColor FDisabled;
	Graphics::TColor FOver;
	Classes::TNotifyEvent FOnChange;
	void __fastcall SetUp(Graphics::TColor Value);
	void __fastcall SetDown(Graphics::TColor Value);
	void __fastcall SetDisabled(Graphics::TColor Value);
	void __fastcall SetOver(Graphics::TColor Value);
	
public:
	__fastcall ThlCaptionColors(void);
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	
__published:
	__property Graphics::TColor Up = {read=FUp, write=SetUp, default=0};
	__property Graphics::TColor Down = {read=FDown, write=SetDown, default=0};
	__property Graphics::TColor Disabled = {read=FDisabled, write=SetDisabled, default=0};
	__property Graphics::TColor Over = {read=FOver, write=SetOver, default=0};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~ThlCaptionColors(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum ThlButtonState { bsUp, bsDown, bsDisabled, bsOver };
#pragma option pop

#pragma option push -b-
enum ThlSwitchMode { smStandard, smToggle };
#pragma option pop

class DELPHICLASS ThlSkinButtonActionLink;
class DELPHICLASS ThlSkinButton;
class DELPHICLASS ThlSkinButtonImage;
class PASCALIMPLEMENTATION ThlSkinButtonImage : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Graphics::TPicture* Picture;
	Extctrls::TImage* Image;
	Controls::TImageList* ImageList;
	unsigned FImageListIndex;
	
protected:
	bool __fastcall GetEmpty(void);
	int __fastcall GetHeight(void);
	HPALETTE __fastcall GetPalette(void);
	int __fastcall GetWidth(void);
	
public:
	__fastcall ThlSkinButtonImage(void);
	void __fastcall Draw(int X, int Y, Graphics::TCanvas* Canvas);
	void __fastcall Reset(void);
	void __fastcall SetSource(Extctrls::TImage* Value)/* overload */;
	void __fastcall SetSource(Graphics::TPicture* Value)/* overload */;
	void __fastcall SetSource(Controls::TImageList* Value)/* overload */;
	__property bool Empty = {read=GetEmpty, nodefault};
	__property unsigned ImageListIndex = {read=FImageListIndex, write=FImageListIndex, nodefault};
	__property HPALETTE Palette = {read=GetPalette, nodefault};
	__property int Height = {read=GetHeight, nodefault};
	__property int Width = {read=GetWidth, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~ThlSkinButtonImage(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION ThlSkinButton : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
private:
	bool AllowResize;
	#pragma pack(push, 1)
	Types::TRect FButtonAreaRect;
	#pragma pack(pop)
	
	bool FChecked;
	Classes::TAlignment FCaptionAlignment;
	ThlCaptionColors* FCaptionColors;
	int FCaptionHorzOffset;
	WideString FCaptionUC;
	int FFocusRectIndent;
	Extctrls::TImage* FImage;
	Controls::TImageList* FImageList;
	unsigned FImageListIndex;
	Classes::TNotifyEvent FOnMouseEnter;
	Classes::TNotifyEvent FOnMouseLeave;
	Graphics::TPicture* FPicture;
	bool FShowFocusRect;
	ThlSwitchMode FSwitchMode;
	Graphics::TColor FTransparentColor;
	bool MouseIsDown;
	bool MouseLeftWhileDown;
	ThlSkinButtonImage* ButtonImage;
	ThlButtonState State;
	void __fastcall CheckOSVersion(void);
	void __fastcall GetSystemColors(void);
	void __fastcall AdjustSizeFromImage(void);
	int __fastcall CalcImageOffset(void);
	Graphics::TColor __fastcall GetCaptionColor(void);
	Types::TPoint __fastcall GetCaptionPosition(Graphics::TCanvas* C);
	void __fastcall Init(bool Resize);
	void __fastcall InitRgn(void);
	bool __fastcall InWindowRgn(const Types::TPoint &Pt);
	bool __fastcall IsCheckedStored(void);
	void __fastcall SetCaptionAlignment(Classes::TAlignment Value);
	void __fastcall SetCaptionColors(ThlCaptionColors* Value);
	void __fastcall SetCaptionHorzOffset(int Value);
	void __fastcall SetCaptionUC(WideString Value);
	void __fastcall SetChecked(bool Value);
	void __fastcall SetImage(Extctrls::TImage* Value);
	void __fastcall SetImageList(Controls::TImageList* Value);
	void __fastcall SetImageListIndex(unsigned Value);
	void __fastcall SetPicture(Graphics::TPicture* Value);
	void __fastcall SetSwitchMode(ThlSwitchMode Value);
	void __fastcall SetTransparentColor(Graphics::TColor Value);
	int __fastcall StripeWidth(void);
	
protected:
	DYNAMIC void __fastcall ActionChange(System::TObject* Sender, bool CheckDefaults);
	virtual bool __fastcall CanResize(int &NewWidth, int &NewHeight);
	void __fastcall CaptionColorsChanged(System::TObject* Sender);
	DYNAMIC void __fastcall ChangeScale(int M, int D);
	HIDESBASE MESSAGE void __fastcall CMEnabledChanged(Messages::TMessage &Message);
	MESSAGE void __fastcall CMTextChanged(Messages::TMessage &Message);
	virtual void __fastcall CreateWnd(void);
	void __fastcall DrawCaption(Graphics::TCanvas* C);
	void __fastcall DrawFocusRect(Graphics::TCanvas* C);
	DYNAMIC TMetaClass* __fastcall GetActionLinkClass(void);
	DYNAMIC HPALETTE __fastcall GetPalette(void);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	virtual void __fastcall Loaded(void);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	MESSAGE void __fastcall MouseLeave(Messages::TMessage &Message);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall Paint(void);
	void __fastcall Reset(void);
	HIDESBASE MESSAGE void __fastcall WMEraseBkgnd(Messages::TWMEraseBkgnd &Msg);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	
public:
	__fastcall virtual ThlSkinButton(Classes::TComponent* AOwner);
	__fastcall virtual ~ThlSkinButton(void);
	__property Types::TRect ButtonAreaRect = {read=FButtonAreaRect, write=FButtonAreaRect};
	__property WideString CaptionUC = {read=FCaptionUC, write=SetCaptionUC};
	
__published:
	__property Classes::TAlignment CaptionAlignment = {read=FCaptionAlignment, write=SetCaptionAlignment, default=2};
	__property ThlCaptionColors* CaptionColors = {read=FCaptionColors, write=SetCaptionColors};
	__property int CaptionHorzOffset = {read=FCaptionHorzOffset, write=SetCaptionHorzOffset, default=0};
	__property bool Checked = {read=FChecked, write=SetChecked, stored=IsCheckedStored, default=0};
	__property int FocusRectIndent = {read=FFocusRectIndent, write=FFocusRectIndent, default=4};
	__property Extctrls::TImage* Image = {read=FImage, write=SetImage};
	__property Controls::TImageList* ImageList = {read=FImageList, write=SetImageList};
	__property unsigned ImageListIndex = {read=FImageListIndex, write=SetImageListIndex, nodefault};
	__property Classes::TNotifyEvent OnMouseEnter = {read=FOnMouseEnter, write=FOnMouseEnter};
	__property Classes::TNotifyEvent OnMouseLeave = {read=FOnMouseLeave, write=FOnMouseLeave};
	__property Graphics::TPicture* Picture = {read=FPicture, write=SetPicture};
	__property bool ShowFocusRect = {read=FShowFocusRect, write=FShowFocusRect, default=1};
	__property ThlSwitchMode SwitchMode = {read=FSwitchMode, write=SetSwitchMode, default=0};
	__property Graphics::TColor TransparentColor = {read=FTransparentColor, write=SetTransparentColor, default=536870911};
	__property Action ;
	__property Anchors  = {default=3};
	__property Caption ;
	__property Enabled  = {default=1};
	__property Font ;
	__property ShowHint ;
	__property ParentFont  = {default=1};
	__property PopupMenu ;
	__property TabOrder  = {default=-1};
	__property TabStop  = {default=0};
	__property Visible  = {default=1};
	__property OnClick ;
	__property OnContextPopup ;
	__property OnKeyDown ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall ThlSkinButton(HWND ParentWindow) : Controls::TCustomControl(ParentWindow) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION ThlSkinButtonActionLink : public Controls::TWinControlActionLink 
{
	typedef Controls::TWinControlActionLink inherited;
	
protected:
	ThlSkinButton* FClient;
	virtual void __fastcall AssignClient(System::TObject* AClient);
	virtual bool __fastcall IsCheckedLinked(void);
	virtual void __fastcall SetChecked(bool Value);
public:
	#pragma option push -w-inl
	/* TBasicActionLink.Create */ inline __fastcall virtual ThlSkinButtonActionLink(System::TObject* AClient) : Controls::TWinControlActionLink(AClient) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TBasicActionLink.Destroy */ inline __fastcall virtual ~ThlSkinButtonActionLink(void) { }
	#pragma option pop
	
};


typedef TMetaClass*ThlSkinButtonActionLinkClass;

//-- var, const, procedure ---------------------------------------------------
static const Shortint InitialHeight = 0x1e;
static const Shortint InitialWidth = 0x50;
static const Shortint InitialCaptionHorzOffset = 0x0;
extern PACKAGE void __fastcall Register(void);

}	/* namespace Hlskinbutton */
using namespace Hlskinbutton;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// hlSkinButton
