// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'hlRockerSwitch.pas' rev: 6.00

#ifndef hlRockerSwitchHPP
#define hlRockerSwitchHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Menus.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Hlrockerswitch
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum ThlLEDShape { ledRectangle, ledEllipse, ledDiamond };
#pragma option pop

class DELPHICLASS ThlRockerSwitchLED;
class PASCALIMPLEMENTATION ThlRockerSwitchLED : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Graphics::TCanvas* parentCanvas;
	Graphics::TColor FColorActive;
	Graphics::TColor FColorInactive;
	Graphics::TColor FColorHighlight;
	Graphics::TColor FColorShadow;
	Graphics::TColor FColorDarkShadow;
	bool FUseDefaultColors;
	bool FAutoInactiveColor;
	bool FShowReflection;
	ThlLEDShape FShape;
	bool FCentered;
	bool FVisible;
	int FLeft;
	int FTop;
	int FWidth;
	int FHeight;
	Classes::TNotifyEvent FOnChange;
	void __fastcall SetColorActive(Graphics::TColor AColorActive);
	void __fastcall SetAutoInactiveColor(bool AAutoInactiveColor);
	void __fastcall SetColorDarkShadow(Graphics::TColor AColorDarkShadow);
	void __fastcall SetHeight(int AHeight);
	void __fastcall SetColorHighlight(Graphics::TColor AColorHighlight);
	void __fastcall SetColorInactive(Graphics::TColor AColorInactive);
	void __fastcall SetLeft(int ALeft);
	void __fastcall SetColorShadow(Graphics::TColor AColorShadow);
	void __fastcall SetShape(ThlLEDShape AShape);
	void __fastcall SetShowReflection(bool AShowReflection);
	void __fastcall SetCentered(bool ACentered);
	void __fastcall SetTop(int ATop);
	void __fastcall SetUseDefaultColors(bool AUseDefaultColors);
	void __fastcall SetVisible(bool AVisible);
	void __fastcall SetWidth(int AWidth);
	Graphics::TColor __fastcall CalcAutoInactiveColor(void);
	void __fastcall PaintRectangle(bool active, int l, int t);
	void __fastcall PaintEllipse(bool active, int l, int t);
	void __fastcall PaintDiamond(bool active, int l, int t);
	
public:
	__fastcall ThlRockerSwitchLED(Graphics::TCanvas* AParentCanvas);
	void __fastcall Paint(bool active, int l, int t);
	void __fastcall ResetSize(void);
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	
__published:
	__property Graphics::TColor ColorActive = {read=FColorActive, write=SetColorActive, default=255};
	__property Graphics::TColor ColorInactive = {read=FColorInactive, write=SetColorInactive, default=127};
	__property Graphics::TColor ColorHighlight = {read=FColorHighlight, write=SetColorHighlight, default=-2147483628};
	__property Graphics::TColor ColorShadow = {read=FColorShadow, write=SetColorShadow, default=-2147483632};
	__property Graphics::TColor ColorDarkShadow = {read=FColorDarkShadow, write=SetColorDarkShadow, default=0};
	__property bool AutoInactiveColor = {read=FAutoInactiveColor, write=SetAutoInactiveColor, default=1};
	__property bool ShowReflection = {read=FShowReflection, write=SetShowReflection, default=1};
	__property ThlLEDShape Shape = {read=FShape, write=SetShape, default=1};
	__property bool Centered = {read=FCentered, write=SetCentered, default=1};
	__property int Left = {read=FLeft, write=SetLeft, default=0};
	__property int Top = {read=FTop, write=SetTop, default=0};
	__property int Width = {read=FWidth, write=SetWidth, default=15};
	__property int Height = {read=FHeight, write=SetHeight, default=15};
	__property bool UseDefaultColors = {read=FUseDefaultColors, write=SetUseDefaultColors, default=1};
	__property bool Visible = {read=FVisible, write=SetVisible, default=1};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~ThlRockerSwitchLED(void) { }
	#pragma option pop
	
};


class DELPHICLASS ThlRockerSwitchColors;
class PASCALIMPLEMENTATION ThlRockerSwitchColors : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Graphics::TColor FColor1;
	Graphics::TColor FColor2;
	Graphics::TColor FColor3;
	Graphics::TColor FColor4;
	Graphics::TColor FColor5;
	Graphics::TColor FColor6;
	bool FUseDefaultColors;
	Classes::TNotifyEvent FOnChange;
	void __fastcall SetColor1(Graphics::TColor AColor1);
	Graphics::TColor __fastcall GetColor1(void);
	void __fastcall SetColor2(Graphics::TColor AColor2);
	Graphics::TColor __fastcall GetColor2(void);
	void __fastcall SetColor3(Graphics::TColor AColor3);
	Graphics::TColor __fastcall GetColor3(void);
	void __fastcall SetColor4(Graphics::TColor AColor4);
	Graphics::TColor __fastcall GetColor4(void);
	void __fastcall SetColor5(Graphics::TColor AColor5);
	Graphics::TColor __fastcall GetColor5(void);
	void __fastcall SetColor6(Graphics::TColor AColor6);
	Graphics::TColor __fastcall GetColor6(void);
	void __fastcall SetUseDefaultcolors(bool AUseDefaultColors);
	
public:
	__fastcall ThlRockerSwitchColors(void);
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	
__published:
	__property bool UseDefaultColors = {read=FUseDefaultColors, write=SetUseDefaultcolors, default=1};
	__property Graphics::TColor Color1 = {read=GetColor1, write=SetColor1, default=16777215};
	__property Graphics::TColor Color2 = {read=GetColor2, write=SetColor2, default=16777215};
	__property Graphics::TColor Color3 = {read=GetColor3, write=SetColor3, default=16777215};
	__property Graphics::TColor Color4 = {read=GetColor4, write=SetColor4, default=16777215};
	__property Graphics::TColor Color5 = {read=GetColor5, write=SetColor5, default=16777215};
	__property Graphics::TColor Color6 = {read=GetColor6, write=SetColor6, default=16777215};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~ThlRockerSwitchColors(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum ThlSwitchOrientation { soVerticalTop, soVerticalBottom, soHorizontalLeft, soHorizontalRight };
#pragma option pop

#pragma option push -b-
enum ThlClickRect { crHalf, crWhole };
#pragma option pop

class DELPHICLASS ThlRockerSwitch;
class PASCALIMPLEMENTATION ThlRockerSwitch : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
private:
	Graphics::TColor FBorderColor;
	int FBorderWidth;
	ThlClickRect FClickRect;
	bool FDrawFocusRect;
	int FFocusRectIndent;
	ThlRockerSwitchLED* FLED;
	bool FOn;
	ThlSwitchOrientation FOrientation;
	ThlRockerSwitchColors* FSwitchColors;
	Graphics::TBitmap* FBufferBmp;
	#pragma pack(push, 1)
	Types::TRect FClickRectOff;
	#pragma pack(pop)
	
	#pragma pack(push, 1)
	Types::TRect FClickRectOn;
	#pragma pack(pop)
	
	int FCurrentStripe;
	bool FDontClick;
	bool FKeyIsDown;
	bool FMouseIsDown;
	void __fastcall CheckOSVersion(void);
	void __fastcall SetBorderColor(Graphics::TColor ABorderColor);
	HIDESBASE void __fastcall SetBorderWidth(int ABorderWidth);
	void __fastcall SetLED(ThlRockerSwitchLED* ALED);
	void __fastcall SetOn(bool AOn);
	void __fastcall SetOrientation(ThlSwitchOrientation AOrientation);
	void __fastcall SetSwitchColors(ThlRockerSwitchColors* AColors);
	void __fastcall PaintSwitches(void);
	void __fastcall PaintLED(void);
	void __fastcall PaintControl(void);
	void __fastcall SetClickRects(void);
	void __fastcall FillOffscreenRect(Graphics::TColor C, int L, int T, int R, int B);
	void __fastcall SetupControl(void);
	HIDESBASE void __fastcall Changed(System::TObject* sender);
	
protected:
	DYNAMIC void __fastcall Resize(void);
	virtual bool __fastcall CanResize(int &NewWidth, int &NewHeight);
	virtual void __fastcall Loaded(void);
	DYNAMIC void __fastcall ChangeScale(int M, int D);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall CMMouseEnter(Messages::TMessage &Msg);
	DYNAMIC void __fastcall Click(void);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	void __fastcall DoDrawFocusRect(void);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	virtual void __fastcall Paint(void);
	HIDESBASE MESSAGE void __fastcall CMSysColorChange(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall WMEraseBkgnd(Messages::TWMEraseBkgnd &Message);
	
public:
	__fastcall virtual ThlRockerSwitch(Classes::TComponent* Owner);
	__fastcall virtual ~ThlRockerSwitch(void);
	
__published:
	__property Graphics::TColor BorderColor = {read=FBorderColor, write=SetBorderColor, default=0};
	__property int BorderWidth = {read=FBorderWidth, write=SetBorderWidth, default=2};
	__property ThlClickRect ClickRect = {read=FClickRect, write=FClickRect, default=0};
	__property bool DrawFocusRect = {read=FDrawFocusRect, write=FDrawFocusRect, default=1};
	__property int FocusRectIndent = {read=FFocusRectIndent, write=FFocusRectIndent, default=0};
	__property ThlRockerSwitchLED* LED = {read=FLED, write=SetLED};
	__property bool On = {read=FOn, write=SetOn, default=0};
	__property ThlSwitchOrientation Orientation = {read=FOrientation, write=SetOrientation, default=0};
	__property ThlRockerSwitchColors* SwitchColors = {read=FSwitchColors, write=SetSwitchColors};
	__property Enabled  = {default=1};
	__property PopupMenu ;
	__property ShowHint ;
	__property TabOrder  = {default=-1};
	__property TabStop  = {default=1};
	__property Visible  = {default=1};
	__property OnClick ;
	__property OnContextPopup ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEnter ;
	__property OnExit ;
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseUp ;
	__property OnMouseMove ;
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall ThlRockerSwitch(HWND ParentWindow) : Controls::TCustomControl(ParentWindow) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Hlrockerswitch */
using namespace Hlrockerswitch;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// hlRockerSwitch
